allData <- readxl::read_excel('data.xlsx', sheet = 'Восток')
allData = transform(allData, LnS=log(S), LnR=log(R), S=NULL, R=NULL)
DataVecOOB <- data.frame(iteration = 1:4)
Data5Predictors <- data.frame(n = 1:5)
Data4Predictors <- data.frame(n = 1:4)
Data3Predictors <- data.frame(n = 1:3)
Data2Predictors <- data.frame(n = 1:2)
library(dplyr) # ради функции filter    
library(randomForest)
for(i in 1:1000) {
  newData <- allData
  vecOOB <- c()
  while (ncol(newData)-1 > 1) {
    set.seed(i)	  
    ## создаем объект случайного леса
    newData.rf <- randomForest(LnR~., data=newData, mtry=2, nodesize=1,
                               importance=TRUE, localImp=TRUE, proximity=TRUE)
    ## именуем данные по важности признаков,   
    ## type = 1 - данные по 'mean decrease in accuracy'
    imp <- importance(newData.rf, type = 1)
    ## устанавливаем критерий для фильтрации,
    ## находим 5%-квантиль, по которому будем отсекать незначимые предикторы 
    quantileProc <- quantile(imp, 0.05)
    ## представляем imp как датафрейм 
    impDataFrame <- as.data.frame(imp)
    ## добавляем в него вектор индексов 
    impDataFrame <- data.frame(MeanDecreaseAcc = impDataFrame$`%IncMSE`, 
                               index = rownames(impDataFrame))
    ## сортируем по уменьшению важности
    impDataFrame <- impDataFrame[order(impDataFrame$MeanDecreaseAcc, decreasing = TRUE),]
    ## если в дата-фрейме остается 5 предикторов, запоминаем их имена
    if ((ncol(newData)-1) == 5) Predictors5 <- impDataFrame$index
    if ((ncol(newData)-1) == 4) Predictors4 <- impDataFrame$index
    if ((ncol(newData)-1) == 3) Predictors3 <- impDataFrame$index
    if ((ncol(newData)-1) == 2) Predictors2 <- impDataFrame$index
    ## фильтруем датафрейм важности по критерию quantileProc
    filterImp <- filter(impDataFrame, impDataFrame$MeanDecreaseAcc <= quantileProc)     
    ## представляем filterImp как вектор 
    filterImpVector <- as.vector(filterImp$index)
    ## находим индексы совпадений
    I <-match(filterImpVector, names(newData), nomatch = 0, incomparables = NULL)  
    ## записываем значение R^2 OOB в вектор
    vecOOB <- c(vecOOB, newData.rf$rsq[newData.rf$ntree])
    ## удаляем признаки с индексом(-ами) I
    newData <- newData[ , -c(I)]
  }
  ## добавляем промежуточные результаты в датафреймы результатов 
  DataVecOOB <- cbind(DataVecOOB, vecOOB)
  Data5Predictors <- cbind(Data5Predictors, Predictors5)
  Data4Predictors <- cbind(Data4Predictors, Predictors4)
  Data3Predictors <- cbind(Data3Predictors, Predictors3)
  Data2Predictors <- cbind(Data2Predictors, Predictors2)
}
  ## удаляем инициализирующие векторы в дата-фреймах результатов
DataVecOOB <- DataVecOOB[, -1]
Data5Predictors<- Data5Predictors[, -1]
Data4Predictors<- Data4Predictors[, -1]
Data3Predictors<- Data3Predictors[, -1]
Data2Predictors<- Data2Predictors[, -1]

writexl::write_xlsx(DataVecOOB, path='OutputOOB.xlsx')
writexl::write_xlsx(Data5Predictors, path='Output5Predictors.xlsx') 
writexl::write_xlsx(Data4Predictors, path='Output4Predictors.xlsx')
writexl::write_xlsx(Data3Predictors, path='Output3Predictors.xlsx')
writexl::write_xlsx(Data2Predictors, path='Output2Predictors.xlsx')

OOBt=as.data.frame(t(DataVecOOB), row.names = FALSE)
names(OOBt)=paste0('n',5:2)
summary(OOBt)
#        n5               n4               n3               n2        
# Min.   :0.3106   Min.   :0.3614   Min.   :0.3306   Min.   :0.3241  
# 1st Qu.:0.3483   1st Qu.:0.4024   1st Qu.:0.4272   1st Qu.:0.4584  
# Median :0.3602   Median :0.4117   Median :0.4375   Median :0.4664  
# Mean   :0.3600   Mean   :0.4119   Mean   :0.4368   Mean   :0.4659  
# 3rd Qu.:0.3726   3rd Qu.:0.4217   3rd Qu.:0.4467   3rd Qu.:0.4740  
# Max.   :0.4073   Max.   :0.4626   Max.   :0.4779   Max.   :0.5015